%% Code to generate Fig6c
% AoD estimation errors for different voltage levels

clear all
close all
clc

T_s = 1; no_sim = 10^6; aspread_doa = 30;

lev_case = 1;
file_load = ['Fig6c_aspread_',num2str(aspread_doa),...
    'T_s_',num2str(T_s),'no_sim',num2str(no_sim),'lcase_',num2str(lev_case),'.mat'];
load(file_load)

figure
semilogy(SNR_dB, (MSE_sd_dod_det), 'k:','LineWidth',1.2)
hold on

no_sim = 10^6;
lev_case = 3;
file_load = ['Fig6c_aspread_',num2str(aspread_doa),...
    'T_s_',num2str(T_s),'no_sim',num2str(no_sim),'lcase_',num2str(lev_case),'.mat'];
load(file_load)
semilogy(SNR_dB, (MSE_sd_dod_det), 'k:x','LineWidth',1.2)
hold on


no_sim = 10^6;
aspread_doa = 30;
file_load =  ['Fig4c_aspread_',num2str(aspread_doa),...
    'T_s_',num2str(T_s),'no_sim',num2str(no_sim),'.mat'];
load(file_load);


semilogy(SNR_dB, (MSE_sd_dod_det), 'b-','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_a_dod_det), 'r--','LineWidth',1.2)


legend('SD, arbitrary c','SD, c from step 1)',...
    'SD, proposed c','UQ');
xlabel('SNR (dB)')
ylabel('AoD estimation error (E_{\phi})')
grid on
ylim([10^(-4) 1.1])
xlim([-15 15])

legend('location','east')
savefig('Fig6c.fig')
saveas(gcf,'Fig6c','epsc')
